import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
 
def createFile(directory_name, file_name, content):
	dedirectory = java.io.File(directory_name);
	defile = java.io.File(directory_name + '/' + file_name);
 
	writer = None;
	try:
		dedirectory.mkdirs();
		defile.createNewFile();
		writer = java.io.FileWriter(defile);
		writer.write(content);
	finally:
		try:
			print 'WRITING FILE ' + file_name;
			if writer != None:
				writer.flush();
				writer.close();
		except java.io.IOException, e:
			e.printStackTrace();
 
print 'CREATE PATHS';
domain_name=os.getenv('DOMAIN_NAME');
server_mode=os.getenv('SERVER_MODE');
java_home=os.getenv('JAVA_HOME');
middleware_home=os.getenv('MIDDLEWARE_HOME');
weblogic_home=os.getenv('WEBLOGIC_HOME');
fusion_middleware_home=os.getenv('FUSION_MIDDLEWARE_HOME');
configuration_home = os.getenv('CONFIGURATION_HOME');

domain_home=configuration_home + '/domains/' + domain_name;
domain_application_home=configuration_home + '/applications/' + domain_name;
node_manager_home=domain_home + '/nodemanager';

print 'domain_name = ' + domain_name;
print 'domain_home = ' + domain_home;
 
weblogic_template=weblogic_home + '/common/templates/wls/wls.jar';
 
print 'CREATE DOMAIN';
readTemplate(weblogic_template);
setOption('DomainName', domain_name);
setOption('OverwriteDomain', 'true');
setOption('JavaHome', java_home);
setOption('ServerStartMode', 'prod');
cd('/Security/base_domain/User/weblogic');
cmo.setName(admin_username);
cmo.setUserPassword(admin_password);
cd('/');
 
print "SAVE DOMAIN";
writeDomain(domain_home);
closeTemplate();

print 'READ DOMAIN';
readDomain(domain_home);

print "SET NODE MANAGER CREDENTIALS";
cd("/SecurityConfiguration/" + domain_name);
cmo.setNodeManagerUsername(node_manager_username);
cmo.setNodeManagerPasswordEncrypted(node_manager_password);

#Added by Eric Robertson 
#         - 21 May 2014
print 'CONFIGURE ADMIN SERVER'
cd('/Server/AdminServer');
set('Name', admin_server_name)
cmo.setListenAddress(admin_server_listen_address)
cmo.setListenPort(int(admin_server_listen_port))
# Finish Add by Eric Robertson

print "DISABLE HOSTNAME VERIFICATION";
cd('/Server/' + admin_server_name);
create(admin_server_name,'SSL');
cd('SSL/' + admin_server_name);
cmo.setHostnameVerificationIgnored(true);
cmo.setHostnameVerifier(None);
cmo.setTwoWaySSLEnabled(false);
cmo.setClientCertificateEnforced(false);
 
print "SET UP DEFAULT AUTHENTICATOR CONFIGURATION"
cd('/SecurityConfiguration/'+ domain_name +'/Realms/myrealm');
# create('LDAPAuthenticator', 'weblogic.security.providers.authentication.LDAPAuthenticator', 'AuthenticationProvider');
 
# change the order of the authentication provider (only works in online mode)
#try:
# set('AuthenticationProviders',jarray.array([ObjectName('Security:Name=myrealmLDAPAuthenticator'), ObjectName('Security:Name=myrealmDefaultAuthenticator'), ObjectName('Security:Name=myrealmDefaultIdentityAsserter')], ObjectName));
#except java.lang.Exception, e:
# dumpStack();
 
cd('AuthenticationProviders/DefaultAuthenticator');
set('ControlFlag', 'SUFFICIENT');
cd('../../');
 
# cd('AuthenticationProviders/LDAPAuthenticator');
# set('ControlFlag', 'SUFFICIENT');
# set('PropagateCauseForLoginException', 'true');
# set('Principal', 'CN=PrincipalUser,CN=Users,DC=mm,DC=local');
# set('CredentialEncrypted', 'password');
# set('Host', 'dc.mm');
# set('UserBaseDN', 'OU=Tenants,DC=mm,DC=local');
# set('AllUsersFilter', '(&(cn=*)(objectclass=user))');
# set('UserFromNameFilter', '(&(cn=%u)(objectclass=user))');
# set('UserObjectClass', 'user');
# set('UserNameAttribute', 'cn');
# set('GroupBaseDN', 'OU=groups,DC=mm,DC=local');
# set('AllGroupsFilter', '(&(cn=*)(objectclass=group))');
# set('GroupFromNameFilter', '(&(cn=%g)(objectclass=group))');
# set('GuidAttribute', 'objectguid');
# set('StaticGroupObjectClass', 'group');
# set('StaticGroupDNsfromMemberDNFilter', '(&(member=%M)(objectclass=group))');
# set('StaticMemberDNAttribute', 'member');
 
print 'SAVE CHANGES';
updateDomain();
closeDomain();

# Added by Barry Egbert 
try:
    print 'UPDATE DOMAIN CDI SETTINGS: ' + domain_cdi_on_off;
        
    if version.find('12.2'):
        readDomain(domain_home);
        create(domain_name,'CdiContainer');
        cd('CdiContainer/'+domain_name);
        set('ImplicitBeanDiscoveryEnabled',0);
        # 1 to enable 0 to disable
        updateDomain();
        closeDomain();
    else:
        print 'WEBLOGIC VERSION: ' + version + ' DOES NOT MATCH 12.2.*. CDI CHANGES WILL NOT BE APPLIED';
except NameError:
    print 'CDI SETTINGS NOT UPDATED. DOMAIN_CDI_ON_OFF VALUE NOT PRESENT.';
 
print 'CREATE FILES';
directory_name = domain_home + '/servers/'+ admin_server_name +'/security';
file_name = 'boot.properties';
content = 'username=' + admin_username + '\npassword=' + admin_password;
createFile(directory_name, file_name, content);
 
directory_name = domain_application_home;
file_name = 'readme.txt';
content = 'This directory contains deployment files and deployment plans.\nTo set-up a deployment, create a directory with the name of the application.\nSubsequently, create two sub-directories called app and plan.\nThe app directory contains the deployment artifact.\nThe plan directory contains the deployment plan.';
createFile(directory_name, file_name, content);
 
directory_name = node_manager_home;
file_name = 'nodemanager.properties';
if node_manager_mode == 'plain':
	content='DomainsFile=' + node_manager_home + '/nodemanager.domains\nLogLimit=0\nPropertiesVersion=12.1\nAuthenticationEnabled=true\nNodeManagerHome=' + node_manager_home + '\nJavaHome=' + java_home +'\nLogLevel=INFO\nDomainsFileEnabled=true\nStartScriptName=startWebLogic.sh\nListenAddress=\nNativeVersionEnabled=true\nListenPort=' + node_manager_listen_port + '\nLogToStderr=true\nSecureListener=false\nLogCount=1\nStopScriptEnabled=false\nQuitEnabled=false\nLogAppend=true\nStateCheckInterval=500\nCrashRecoveryEnabled=true\nStartScriptEnabled=true\nLogFile=' + node_manager_home + '/nodemanager.log\nLogFormatter=weblogic.nodemanager.server.LogFormatter\nListenBacklog=50';
else:
  content='DomainsFile=' + node_manager_home + '/nodemanager.domains\nLogLimit=0\nPropertiesVersion=12.1\nAuthenticationEnabled=true\nNodeManagerHome=' + node_manager_home + '\nJavaHome=' + java_home +'\nLogLevel=INFO\nDomainsFileEnabled=true\nStartScriptName=startWebLogic.sh\nListenAddress=\nNativeVersionEnabled=true\nListenPort=' + node_manager_listen_port + '\nLogToStderr=true\nSecureListener=false\nLogCount=1\nStopScriptEnabled=false\nQuitEnabled=false\nLogAppend=true\nStateCheckInterval=500\nCrashRecoveryEnabled=true\nStartScriptEnabled=true\nLogFile=' + node_manager_home + '/nodemanager.log\nLogFormatter=weblogic.nodemanager.server.LogFormatter\nListenBacklog=50';
createFile(directory_name, file_name, content);

